<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2014-09-28 10:16
 */
interface MInsuranceDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return MInsurance 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param mInsurance primary key
 	 */
	public function delete($insuranceId);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param MInsurance mInsurance
 	 */
	public function insert($mInsurance);
	
	/**
 	 * Update record in table
 	 *
 	 * @param MInsurance mInsurance
 	 */
	public function update($mInsurance);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByOurSerial($value);

	public function queryByStageIdBefore($value);

	public function queryByCurrentStage($value);

	public function queryByShipNameGo($value);

	public function queryByShipCompanyGo($value);

	public function queryByShipPersonalGo($value);

	public function queryByShipCostGo($value);

	public function queryByShipNameReturned($value);

	public function queryByShipCompanyReturned($value);

	public function queryByShipPersonalReturned($value);

	public function queryByShipCostReturned($value);

	public function queryByType($value);

	public function queryByOldSN($value);

	public function queryByNewSN($value);

	public function queryByInsuranceCost($value);

	public function queryByKindOfInsurance($value);

	public function queryByInsuranceDate($value);

	public function queryByInsuranceDiscount($value);

	public function queryByUserId($value);

	public function queryByBranchId($value);

	public function queryByComment($value);

	public function queryByDel($value);

	public function queryByReturned($value);


	public function deleteByOurSerial($value);

	public function deleteByStageIdBefore($value);

	public function deleteByCurrentStage($value);

	public function deleteByShipNameGo($value);

	public function deleteByShipCompanyGo($value);

	public function deleteByShipPersonalGo($value);

	public function deleteByShipCostGo($value);

	public function deleteByShipNameReturned($value);

	public function deleteByShipCompanyReturned($value);

	public function deleteByShipPersonalReturned($value);

	public function deleteByShipCostReturned($value);

	public function deleteByType($value);

	public function deleteByOldSN($value);

	public function deleteByNewSN($value);

	public function deleteByInsuranceCost($value);

	public function deleteByKindOfInsurance($value);

	public function deleteByInsuranceDate($value);

	public function deleteByInsuranceDiscount($value);

	public function deleteByUserId($value);

	public function deleteByBranchId($value);

	public function deleteByComment($value);

	public function deleteByDel($value);

	public function deleteByReturned($value);


}
?>